package chess4j.board;

import java.util.ArrayList;
import java.util.List;

public class KnightSquares {

	public static List<Square> getSquares(Square sq) {
		List<Square> knightSquares = new ArrayList<Square>();
		Rank rank = sq.rank();
		File file = sq.file();
		
		// north 2, west 1
		if (rank.southOf(Rank.RANK_7) && file.eastOf(File.FILE_A)) 
			knightSquares.add(Square.valueOf(file.west(), rank.north().north()));
		// north 2, east 1
		if (rank.southOf(Rank.RANK_7) && file.westOf(File.FILE_H)) 
			knightSquares.add(Square.valueOf(file.east(), rank.north().north()));
		// north 1, west 2
		if (rank.southOf(Rank.RANK_8) && file.eastOf(File.FILE_B)) 
			knightSquares.add(Square.valueOf(file.west().west(), rank.north()));
		// north 1, east 2
		if (rank.southOf(Rank.RANK_8) && file.westOf(File.FILE_G)) 
			knightSquares.add(Square.valueOf(file.east().east(), rank.north()));
		// south 2, west 1
		if (rank.northOf(Rank.RANK_2) && file.eastOf(File.FILE_A)) 
			knightSquares.add(Square.valueOf(file.west(), rank.south().south()));
		// south 2, east 1
		if (rank.northOf(Rank.RANK_2) && file.westOf(File.FILE_H)) 
			knightSquares.add(Square.valueOf(file.east(), rank.south().south()));
		// south 1, west 2
		if (rank.northOf(Rank.RANK_1) && file.eastOf(File.FILE_B)) 
			knightSquares.add(Square.valueOf(file.west().west(), rank.south()));
		// south 1, east 2
		if (rank.northOf(Rank.RANK_1) && file.westOf(File.FILE_G)) 
			knightSquares.add(Square.valueOf(file.east().east(), rank.south()));
		
		return knightSquares;
	}

}
